var scrollObj = new Array();

var scrollTags = {
    opt:{
        hScroll:true,
        vScroll:false,
        bounce:true,
        momentum:true
    },
    init:function(_id) {
        scrollObj[_id] = this.makeScroll(_id, this.opt);
        $(window).on("resize", function() {
            scrollObj[_id].refresh();
            resizeImg();
        });
        $(".selectList a.cur").each(function(k, e) {
            if (!$("#" + _id + " a.cur")[0]) {
                return;
            }
            var screenWidth = $(".header").width();
            var aLeft = $("#" + _id + " a.cur").offset().left;
            var aWidth = $("#" + _id + " a.cur").width();
            var scrollLeft = parseInt(screenWidth - aLeft);
            if (scrollLeft < 30) {
                scrollObj[_id].scrollTo(-aLeft + aWidth);
            }
        });
        return scrollObj[_id];
    },
    makeScroll:function(_id, _opt) {
        return new iScroll(_id, _opt);
    }
};

scrollTags.init("first_list");

scrollTags.init("second_list");

scrollTags.init("third_list");



$(".selectBtn").click(function() {
    if ($(this).hasClass("cur") && !$(this).parent().hasClass("fixed")) {
        $(".selectBtn").removeClass("cur");
        $(".selectList").hide();
    } else {
        $(".selectList").show();
        $(".selectBtn").addClass("cur");
        $(".selectList p").each(function(k, e) {
            $(this).parent().css({
                width:$(this).width()
            });
        });
        !scrollObj["first_list"] && scrollTags.init("first_list");
        !scrollObj["second_list"] && scrollTags.init("second_list");
        !scrollObj["third_list"] && scrollTags.init("third_list");
        !scrollObj["listtitle"] && scrollTags.init("listtitle");
        for (var i in scrollObj) {
            scrollObj[i].refresh();
        }
    }
    reSizeSetTab();
    if ($(this).parent().hasClass("fixed")) {
        scroll(0, 0);
    }
});

$(".selectList a,.pList a").click(function() {
    if ($(this).parent().hasClass("pList")) {
        scroll(0, 0);
    } else {
        $("#actors").attr({
            "data-param":""
        });
    }
    if ($(this).attr("data-clear")) {
        var clear = $(this).attr("data-clear");
        if (clear == "all") {
            $(".selectList a").removeClass("cur");
            $("#first_list a").first().addClass("cur");
            $("#second_list a").first().addClass("cur");
        }
        if (clear != "all") {
            $("#" + clear + " a").removeClass("cur");
            $("#" + clear + " a").first().addClass("cur");
        }
    }
    $($(this).parent()).children().removeClass("cur");
    $(this).addClass("cur");
    if ($(this).parent().hasClass("pList")) {
        var indexOf = $(this).index();
        $(".pList a").removeClass("cur");
        $($(".pList a")[indexOf]).addClass("cur");
        $($(".pList a")[indexOf + 3]).addClass("cur");
    }
    scrollMore.isScrolled = 1;
    var url = createUrl();
    var seoUrl = dealSeoUrl.parseUrl();
    var refererCookie = "m_list_referer=" + escape(seoUrl);
    refererCookie += ";path=/;domain=.2345.com;";
    document.cookie = refererCookie;
    $("#page_more").parent().hide();
    $("#data_list").hide();
    $("#noneData").hide();
    $("#listLoading").show();
    $.ajax({
        type:"get",
        url:url,
        data:{
            is_ajax:1
        },
        success:function(json) {
            $("#page_more").attr("data-url", url);
            $("#data_list").html("");
            $("#listLoading").hide();
            if (json) {
                var _json = eval("(" + json + ")");
                var _html = createHtml(_json["movie_data"], _json["type"]);
                $("#data_list").html(_html);
                $("#page_more").attr("data-total", _json["page_num"]);
                if (_json["page_num"] > 1) {
                    $("#page_more").attr("data-page", 2);
                    scrollMore.isScrolled = 0;
                    $("#page_more").parent().show();
                }
                $("#data_list").show();
            } else {
                $("#noneData").show();
            }
            resizeImg();
        },
        error:function() {}
    });
});


$("#data_list img").lazyload({
    data_attribute:"src",
    threshold:30
});

function resizeImg() {
    var width = $("#data_list").width();
    height = $("#data_list").height();
    width = parseInt(width * .31999);
    height = parseInt(260 * (width / 195));
    $("#data_list img").css({
        width:width,
        height:height
    });
    $("#data_list a").css({
        width:width,
        height:height
    });
}

resizeImg();

var pageMore = {
    pageTotal:0,
    init:function(ele) {
        this.pageTotal = $(ele).attr("data-total");
        $(ele).click(function() {
            pageMore.nextPage(ele);
        });
    },
    nextPage:function(ele) {
        scrollMore.isScrolled = 1;
        var _page = $(ele).attr("data-page");
        if (!_page) {
            return false;
        }
        $(ele).parent().hide();
        $("#loading_more").show();
        var url = createUrl();
        $.ajax({
            url:url,
            data:{
                page:_page,
                is_ajax:1
            },
            type:"get",
            charset:"gb2312",
            success:function(json) {
                if (json) {
                    var _json = eval("(" + json + ")");
                    var _html = createHtml(_json["movie_data"], _json["type"]);
                    var pageTotal = _json["page_num"];
                    $("#loading_more").hide();
                    $("#data_list").append(_html);
                    resizeImg();
                    var pageNext = parseInt(_page) + 1;
                    if (pageNext <= pageTotal) {
                        $(ele).attr("data-page", pageNext);
                        if (pageNext % 6 > 0) {
                            scrollMore.isScrolled = 0;
                        } else {
                            $(ele).parent().show();
                        }
                    } else {
                        $(ele).parent().hide();
                    }
                } else {
                    $(ele).parent().hide();
                }
            }
        });
    }
};

if ($("#page_more")) {
    pageMore.init("#page_more");
}

var scrollMore = {
    isScrolled:0,
    init:function() {
        if (!$("#page_more")[0]) {
            return;
        }
        this.bindScroll($("#page_more"));
    },
    bindScroll:function(_ele) {
        $(window).scroll(function() {
            var pageTotal = parseInt($("#page_more").attr("data-total"));
            var pageNow = parseInt($("#page_more").attr("data-page"));
            var scrollTop = $(this).scrollTop();
            var scrollHeight = $(".wrapper").height() - scrollTop - $(document).height();
            if (scrollHeight <= 30 && !scrollMore.isScrolled && pageTotal >= pageNow) {
                pageMore.nextPage(_ele);
            }
        });
        return;
    }
};

scrollMore.init();

var tab = document.getElementById("tab");

var tabHeight = tab.offsetTop, scrollNum;

function reSizeSetTab() {
    tabHeight = tab.offsetTop;
    setTab();
}

function setTab() {
    if (tabHeight < document.documentElement.scrollTop + document.body.scrollTop) {
        tab.className = "tab globalPadding clearfix fixed";
    } else {
        tab.className = "tab globalPadding clearfix";
    }
}

window.onscroll = setTab;

window.onresize = reSizeSetTab;