var sliderTimeout, timeOut = 2000,
    bodyWidth = 0,
    changeValue;

function setHeight() {
    $("#focusCon").css({
        'height': ''
    });
    changeValue = bodyWidth = document.body.clientWidth;
    var height = Math.round(bodyWidth * 227 / 480);
    $("#focusCon").css({
        'height': height
    });
    clearTimeout(sliderTimeout);
    sliderTimeout = setTimeout(autoPlay, timeOut)
}
window.onload = setHeight();
$(window).on('resize', function() {
    setHeight()
});
var focusConArr = $("#focusCon li"),
    focusTabArr = $("#focusTab i"),
    prevIndex = nextIndex = 0,
    focuscListLength = focusConArr.length,
    currentTime = 0,
    durationTime = 50,
    isFocusLoaded = false;
animateIng = false;

function foucsAnimate(prev, next, widthNum, className, durationTime, currentTime, changeValue) {
    clearTimeout(sliderTimeout);
    !isFocusLoaded && $("#focusCon img").each(function() {
        if ($(this).attr('data-src')) {
            $(this).attr('src', $(this).attr('data-src'));
            $(this).attr('data-src', '')
        }
        isFocusLoaded = true
    });
    $(focusConArr[prev]).css({
        "left": "0px"
    }).addClass(className);
    $(focusConArr[next]).css({
        "left": widthNum
    }).addClass(className);
    animateIng = true;

    function Run() {
        $(focusConArr[prev]).css({
            "left": Math.ceil(animateEaseIn(currentTime, 0, -changeValue, durationTime)) + "px"
        });
        $(focusConArr[next]).css({
            "left": Math.ceil(animateEaseIn(currentTime, changeValue, -changeValue, durationTime)) + "px"
        });
        if (currentTime < durationTime) {
            currentTime++;
            setTimeout(Run, 6.5)
        } else {
            $(focusConArr[prev]).removeClass(className);
            animateIng = false;
            currentTime = 0;
            sliderTimeout = setTimeout(autoPlay, timeOut);
            changeValue = Math.abs(changeValue)
        }
    }
    Run();
    $(focusTabArr[prev]).removeClass(className);
    $(focusTabArr[next]).addClass(className)
}

function autoPlay() {
    prevIndex = nextIndex;
    nextIndex++;
    if (nextIndex == focuscListLength) {
        nextIndex = 0
    }
    foucsAnimate(prevIndex, nextIndex, bodyWidth, "cur", durationTime, currentTime, changeValue)
}

function animateEaseIn(t, b, c, d) {
    return c * (t /= d) * t + b
}
var startTouchX = endTouchX = 0;
var moveY = 0;

function touchstart(event) {
    clearTimeout(sliderTimeout);
    startTouchX = event.touches[0].pageX;
    moveY = event.touches[0].pageY
}

function touchmove(event) {
    if (Math.abs(event.touches[0].pageY - moveY) < 8) {
        event.preventDefault()
    }
    endTouchX = event.touches[0].pageX
}

function touchend(event) {
    if (animateIng === false) {
        changeValue = Math.abs(changeValue);
        prevIndex = nextIndex;
        if (endTouchX > (startTouchX + 30)) {
            changeValue = -changeValue;
            nextIndex--;
            if (nextIndex == -1) {
                nextIndex = focuscListLength - 1
            }
            foucsAnimate(prevIndex, nextIndex, bodyWidth, "cur", durationTime, currentTime, changeValue)
        } else if ((endTouchX + 30) < startTouchX) {
            nextIndex++;
            if (nextIndex == focuscListLength) {
                nextIndex = 0
            }
            foucsAnimate(prevIndex, nextIndex, bodyWidth, "cur", durationTime, currentTime, changeValue)
        } else {
            sliderTimeout = setTimeout(autoPlay, timeOut)
        }
    }
    changeValue = Math.abs(changeValue)
}
//$('#focusCon')[0].addEventListener('touchstart', touchstart, false);
//$('#focusCon')[0].addEventListener('touchmove', touchmove, false);
//$('#focusCon')[0].addEventListener('touchend', touchend, false);
$('.globalPadding img').lazyload({
    data_attribute: 'src'
});
(function() {
    var addDesk = document.cookie.indexOf('addDesk');
    addDesk = addDesk != -1;
    var ipUa = navigator.userAgent;
    var ipUaLower = ipUa.toLowerCase();
    if (!addDesk && ipUaLower.indexOf('iphone') != -1 && ipUa.indexOf("Safari") != -1 && ipUaLower.indexOf("version") != -1 && ipUaLower.indexOf("qqbrowser") === -1 && ipUaLower.indexOf("ucbrowser") === -1 && ipUaLower.indexOf("baidu") === -1 && ipUaLower.indexOf("chrome") === -1) {
        var ios = navigator.userAgent.match(/(iPhone)\s+OS\s([\d_\.]+)/);
        if (ios) {
            var version = ios[2].replace(/_/g, '.');
            var vers = /^7/.test(version);
            if (vers) {
                $(".ico_adddesktop_ios").addClass("ico_adddesktop_ios7")
            }
            $(".addDesktop").show()
        }
    }
    $('.closeclick_phone').click(function() {
        $(".addDesktop").hide();
        var exp = new Date();
        exp.setTime(exp.getTime() + 300 * 86400 * 1000);
        var addFlag = 'addDesk=1;path=/;domain=.2345.com;expires=' + exp.toGMTString();
        document.cookie = addFlag
    })
})();
